@extends('backend::pages.module')

@section('moduleTitle')
    <i class="fa fa-laptop"></i> {{ trans('Report::report.title') }}
@endsection
@section('moduleDescription')
    @if($request['from_date']) {{ Carbon\Carbon::parse($request['from_date'])->format('jS F Y') }}  - @endif
    @if($request['to_date']) {{ Carbon\Carbon::parse($request['to_date'])->format('jS F Y') }} @endif
@endsection

@section('moduleBreadcrumb')
    <li><a href="{{ route('report.list') }}"><i class="fa fa-laptop"></i>{{ trans('Report::report.breadcrumb.first') }}</a></li>
    <li class="active">{{ trans('Report::report.breadcrumb.second') }}</li>
@endsection

@section('moduleContent')
    <div class="row">
        <div class="col-xs-12">
            <div class="box">
                <div class="box-header">
                    <section class="content-header">
                        <h1 class="box-title">
                            @yield('moduleTitle', 'New Monule')
                            <small>@yield('moduleDescription', 'Optional description')</small>
                        </h1>
                        <ol class="breadcrumb">
                            @yield('moduleBreadcrumb', '
                                 <li><a href="#"><i class="fa fa-dashboard"></i> Level</a></li>
                                 <li class="active">Here</li>
                            ')
                        </ol>
                    </section>
                </div><!-- /.box-header -->
                <div class="box-body">
                    <table id="reports-table" class="table table-bordered table-striped">
                        <thead>
                        <tr>
                            <th class="col-sm-1">{{ trans('Invoice::invoice.inputs.serial') }}#</th>
                            <th>{{ trans('Invoice::invoice.inputs.client') }}</th>
                            <th>{{ trans('Invoice::invoice.inputs.create_date') }}</th>
                            <th>{{ trans('Invoice::invoice.inputs.due_date') }}</th>
                            <th>{{ trans('Invoice::invoice.inputs.grand_total') }}</th>
                            <th>{{ trans('Invoice::invoice.inputs.payment_status') }}</th>
                            <th>{{ trans('Invoice::invoice.inputs.paid_amount') }}</th>
                        </tr>
                        </thead>
                        <tfoot>
                            <tr>
                                <th colspan="6" class="text-right"> Total</th>
                                <th></th>
                            </tr>
                        </tfoot>
                    </table>
                </div><!-- /.box-body -->
            </div><!-- /.box -->
        </div>
    </div>

@endsection


@push('footerAssetPush')
<script>
    $(function() {
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
        var from_date   = '{!! $request['from_date'] !!}';
        var to_date     = '{!! $request['to_date'] !!}';
        var client_id   = '{!! $request['client_id'] !!}';

        var t = $('#reports-table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: '{{ route("report.list.datatable") }}',
                method: 'POST',
                data: { from_date:from_date, to_date:to_date, client_id:client_id },
            },
            buttons: [
                'csv', 'excel', 'pdf', 'print', 'reset', 'reload'
            ],
            columns: [
                {data: 'serial', name: 'serial'},
                {data: 'client', name: 'client'},
                {data: 'create_date', name: 'create_date'},
                {data: 'due_date', name: 'due_date'},
                {data: 'grand_total', name: 'grand_total'},
                {data: 'payment_status', name: 'payment_status'},
                {data: 'total_paid', name: 'total_paid'}
            ],
            footerCallback: function( tfoot, data, start, end, display ) {
                var iTotalMarket = 0;
                for ( var i=0 ; i<data.length ; i++ )
                {
                    iTotalMarket += data[i]['total_paid']*1;
                }
                console.log(iTotalMarket);
                $(tfoot).find('th').eq(1).html( iTotalMarket );
            },
            order: [[0, "asc"]],
            searchDelay: 500

        });

    });
</script>
@endpush