<?php
/*
| -------------------------------------------------------------
| iBill - Simplest and Best Billing & Invoice Manager
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net
| -------------------------------------------------------------
| COPYRIGHT:        RESERVED BY INILABS IT
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/
namespace Modules\Settings\Requests;

use App\Http\Requests\Request;

class SettingsRequest extends Request
{

    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        session(['tab' => 'settings']);
        switch($this->method())
        {
            case 'GET':
            case 'DELETE':
            {
                return [];
            }
            case 'POST':
            {
                return [];
            }
            case 'PUT':
            case 'PATCH':
            {
                return [
                    'sitename' => 'required|max:15',
                    'siteemail' => 'required|email',
                    'sitefooter' => 'max:120',
                    'sitephone' => 'numeric',
                    'siteaddress' => 'required',
                    'sitecity' => 'required',
                    'sitezipcode' => '',
                    'sitestate' => '',
                    'sitecountry' => 'required',
                    'backendtheme' => '',
                    'frontendtheme' => '',
                ];
            }
            default:break;
        }
    }
}
