<?php
/*
| -------------------------------------------------------------
| iBill - Simplest and Best Billing & Invoice Manager
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net
| -------------------------------------------------------------
| COPYRIGHT:        RESERVED BY INILABS IT
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/
namespace Modules\Settings\Requests;

use App\Http\Requests\Request;

class SocialRequest extends Request
{

    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        session(['tab' => 'social']);
        switch($this->method())
        {
            case 'GET':
            case 'DELETE':
            {
                return [];
            }
            case 'POST':
            {
                return [];
            }
            case 'PUT':
            case 'PATCH':
            {
                return [
                    'github_client_id' => '',
                    'github_client_secret' => '',
                    'facebook_client_id' => '',
                    'facebook_client_secret' => '',
                    'google_client_id' => '',
                    'google_client_secret' => '',
                ];
            }
            default:break;
        }
    }
}
