<?php
/*
| -------------------------------------------------------------
| iStart - Laravel Multi Admin+Frontend Theme and Startup Tools
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net
| -------------------------------------------------------------
| COPYRIGHT:        RESERVED BY INILABS IT
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/
namespace Modules\Settings\Services;

use Modules\Settings\Models\Settings;

class Get
{

    protected $settings;

    function __construct()
    {
        $this->settings = Settings::where('option', 'like', 'frontend%')->pluck('value', 'option')->all();
    }

    public function socialLinks()
    {
        $links = [
            'facebook'  =>   $this->settings['frontendfacebooklink'],
            'google'    =>   $this->settings['frontendgooglelink'],
            'twitter'   =>   $this->settings['frontendtwitterlink']
        ];
        return $links;
    }

    public function facebookLink()
    {
        return isset($this->settings['frontendfacebooklink']) ? $this->settings['frontendfacebooklink'] : '';
    }

    public function googleLink()
    {
        return isset($this->settings['frontendgooglelink']) ? $this->settings['frontendgooglelink'] : '';
    }

    public function twitterLink()
    {
        return isset($this->settings['frontendtwitterlink']) ? $this->settings['frontendtwitterlink'] : '';
    }

    public function getFooter()
    {
        return isset($this->settings['frontendfooter']) ? $this->settings['frontendfooter'] : '';
    }

    public function getLogo()
    {
        return isset($this->settings['frontendlogo']) ? $this->settings['frontendlogo'] : '';
    }

    public function getSiteName()
    {
        return isset($this->settings['frontendsitename']) ? $this->settings['frontendsitename'] : '';
    }

    public function getSiteFavicon()
    {
        return isset($this->settings['frontendlogo']) ? $this->settings['frontendlogo'] : '';
    }

    public function getSiteSubTitle()
    {
        return isset($this->settings['frontendsitesubtitle']) ? $this->settings['frontendsitesubtitle'] : '';
    }

    public function getAbout()
    {
        return isset($this->settings['frontendabout']) ? $this->settings['frontendabout'] : '';
    }
}