@if (count($errors) > 0)
    <div class="alert alert-danger">
        <ul>
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif
{!! Form::model($settings, [
    'method' => 'PATCH',
    'route' => ['settings.update'],
    'class' => '',
    'enctype' => 'multipart/form-data'
]) !!}
    <div class="row">
        <div class="col-lg-12">

            <div class="form-group col-lg-6 {{ $errors->has('sitename') ? ' has-error' : '' }} has-feedback">
                {!! Form::label('sitename', trans('Settings::settings.inputs.backend.sitename'), ['class' => '']) !!}
                {!! Form::text('sitename', null, ['class' => 'form-control', 'required' => 'required']) !!}
                {!! $errors->first('sitename', '<span class="help-block">:message</span>') !!}
            </div>

            <div class="form-group col-lg-6 {{ $errors->has('sitesortname') ? ' has-error' : '' }} has-feedback">
                {!! Form::label('sitesortname', trans('Settings::settings.inputs.backend.sitesortname'), ['class' => '']) !!}
                {!! Form::text('sitesortname', null, ['class' => 'form-control']) !!}
                {!! $errors->first('sitesortname', '<span class="help-block">:message</span>') !!}
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-12">
            <div class="form-group col-lg-6 {{ $errors->has('siteemail') ? ' has-error' : '' }} has-feedback">
                {!! Form::label('siteemail', trans('Settings::settings.inputs.backend.siteemail'), ['class' => '']) !!}
                {!! Form::text('siteemail', null, ['class' => 'form-control', 'required' => 'required']) !!}
                {!! $errors->first('siteemail', '<span class="help-block">:message</span>') !!}
            </div>

            <div class="form-group col-lg-6 {{ $errors->has('sitephone') ? ' has-error' : '' }} has-feedback">
                {!! Form::label('sitephone', trans('Settings::settings.inputs.backend.sitephone'), ['class' => '']) !!}
                {!! Form::text('sitephone', null, ['class' => 'form-control']) !!}
                {!! $errors->first('sitephone', '<span class="help-block">:message</span>') !!}
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-lg-12">
            <div class="form-group col-lg-6 {{ $errors->has('siteaddress') ? ' has-error' : '' }} has-feedback">
                {!! Form::label('siteaddress', trans('Settings::settings.inputs.backend.siteaddress'), ['class' => '']) !!}
                {!! Form::text('siteaddress', null, ['class' => 'form-control', 'required' => 'required']) !!}
                {!! $errors->first('siteaddress', '<span class="help-block">:message</span>') !!}
            </div>

            <div class="form-group col-lg-6 {{ $errors->has('sitecity') ? ' has-error' : '' }} has-feedback">
                {!! Form::label('sitecity', trans('Settings::settings.inputs.backend.sitecity'), ['class' => '']) !!}
                {!! Form::text('sitecity', null, ['class' => 'form-control']) !!}
                {!! $errors->first('sitecity', '<span class="help-block">:message</span>') !!}
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-lg-12">
            <div class="form-group col-lg-6 {{ $errors->has('sitezipcode') ? ' has-error' : '' }} has-feedback">
                {!! Form::label('sitezipcode', trans('Settings::settings.inputs.backend.sitezipcode'), ['class' => '']) !!}
                {!! Form::text('sitezipcode', null, ['class' => 'form-control', 'required' => 'required']) !!}
                {!! $errors->first('sitezipcode', '<span class="help-block">:message</span>') !!}
            </div>

            <div class="form-group col-lg-6 {{ $errors->has('sitestate') ? ' has-error' : '' }} has-feedback">
                {!! Form::label('sitestate', trans('Settings::settings.inputs.backend.sitestate'), ['class' => '']) !!}
                {!! Form::text('sitestate', null, ['class' => 'form-control']) !!}
                {!! $errors->first('sitestate', '<span class="help-block">:message</span>') !!}
            </div>
        </div>
    </div>


    <div class="row">
        <div class="col-lg-12">
            <div class="form-group col-lg-6 {{ $errors->has('sitefooter') ? ' has-error' : '' }} has-feedback">
                {!! Form::label('sitefooter', trans('Settings::settings.inputs.backend.sitefooter'), ['class' => '']) !!}
                {!! Form::text('sitefooter', null, ['class' => 'form-control']) !!}
                {!! $errors->first('sitefooter', '<span class="help-block">:message</span>') !!}
            </div>

            <div class="form-group col-lg-6 {{ $errors->has('analyticsgoogle') ? ' has-error' : '' }} has-feedback">
                {!! Form::label('analyticsgoogle', trans('Settings::settings.inputs.backend.analyticsgoogle'), ['class' => '']) !!}
                {!! Form::text('analyticsgoogle', null, ['class' => 'form-control']) !!}
                {!! $errors->first('analyticsgoogle', '<span class="help-block">:message</span>') !!}
            </div>
        </div>
    </div>

    @if(config('core.switch.enable.frontend'))
        <div class="row">
            <div class="col-lg-12">
                <div class="form-group col-lg-6 {{ $errors->has('havefrontend') ? ' has-error' : '' }} has-feedback">
                    {!! Form::label('havefrontend', trans('Settings::settings.inputs.backend.havefrontend'), ['class' => '']) !!}
                    {!! Form::select('havefrontend', ['yes' => 'Yes', 'no' => "No"], null, ['placeholder' => 'Have Frontend Theme', 'class' => 'form-control', 'required' => 'required']) !!}
                    {!! $errors->first('havefrontend', '<span class="help-block">:message</span>') !!}
                </div>

                <div class="form-group col-lg-6 {{ $errors->has('frontendtheme') ? ' has-error' : '' }} has-feedback">
                    {!! Form::label('frontendtheme', trans('Settings::settings.inputs.backend.frontendtheme.label'), ['class' => '']) !!}
                    {!! Form::select('frontendtheme', $frontendTheme, null, ['placeholder' => trans('Settings::settings.inputs.backend.frontendtheme.select'), 'class' => 'form-control']) !!}
                    {!! $errors->first('frontendtheme', '<span class="help-block">:message</span>') !!}
                </div>
            </div>
        </div>
    @endif

    <div class="row">
        <div class="col-lg-12">
            <div class="form-group col-lg-6 {{ $errors->has('sitecountry') ? ' has-error' : '' }} has-feedback">
                {!! Form::label('sitecountry', trans('Settings::settings.inputs.backend.sitecountry'), ['class' => '']) !!}
                {!! Form::select('sitecountry', $countries, null, ['class' => 'form-control select2', 'required' => 'required']) !!}
                {!! $errors->first('sitecountry', '<span class="help-block">:message</span>') !!}
            </div>
            <div class="form-group @if(config('core.switch.enable.backend')) col-lg-6 @else col-lg-12 @endif {{ $errors->has('sitefavicon') ? ' has-error' : '' }} has-feedback">

                {!! Form::label('sitefavicon', trans('Settings::settings.inputs.backend.favicon'), ['class' => '']) !!}

                <div class="input-group banner">
                    <input type="text" class="form-control banner-filename" disabled="disabled">
                    <span class="input-group-btn">
                            <button type="button" class="btn btn-default banner-clear" style="display:none;">
                                <span class="fa fa-remove"></span>
                                Clear
                            </button>
                            <div class="btn btn-primary banner-input">
                                <span class="fa fa-repeat"></span>
                                <span class="banner-input-title">
                                    File Browse
                                </span>
                                {!! Form::file('sitefavicon', null, ['class' => 'file']) !!}
                            </div>
                        </span>
                </div>

                {!! $errors->first('sitefavicon', '<span class="help-block">:message</span>') !!}

            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-lg-12">
            <div class="form-group col-lg-6 {{ $errors->has('frontendlogo') ? ' has-error' : '' }} has-feedback">

                {!! Form::label('frontendlogo', trans('Settings::settings.inputs.frontend.logo'), ['class' => '']) !!}

                <div class="input-group logo">
                    <input type="text" class="form-control logo-filename" disabled="disabled">
                    <span class="input-group-btn">
                        <button type="button" class="btn btn-default logo-clear" style="display:none;">
                            <span class="fa fa-remove"></span>
                            Clear
                        </button>
                        <div class="btn btn-primary logo-input">
                            <span class="fa fa-repeat"></span>
                            <span class="logo-input-title">
                                File Browse
                            </span>
                            {!! Form::file('frontendlogo', null, ['class' => 'file']) !!}
                        </div>
                    </span>
                </div>

                {!! $errors->first('frontendlogo', '<span class="help-block">:message</span>') !!}

            </div>
            @if(config('core.switch.enable.backend'))
                {{--<div class="form-group col-lg-6 {{ $errors->has('backendtheme') ? ' has-error' : '' }} has-feedback">--}}
                    {{--{!! Form::label('backendtheme', trans('Settings::settings.inputs.backend.backendtheme.label'), ['class' => '']) !!}--}}
                    {{--{!! Form::select('backendtheme', $backendTheme, null, ['placeholder' => trans('Settings::settings.inputs.backend.backendtheme.select'), 'class' => 'form-control']) !!}--}}
                    {{--{!! $errors->first('backendtheme', '<span class="help-block">:message</span>') !!}--}}
                {{--</div>--}}
            @endif

        </div>
    </div>

<div class="col-lg-3">
        <div class="form-group">
            {!! Form::submit($submitButton, ['class' => 'btn btn-success form-control']) !!}
        </div>
    </div>
{{ Form::close() }}
@push('headerAssetPush')
<link rel="stylesheet" href="{{ url('bassets/plugins/select2/select2.min.css') }}">
<style type="text/css">
    .banner-input {
        background-color: #2e4760;
        border-color: #2e4760;
        color: #fff;
        margin: 0;
        overflow: hidden;
        position: relative;
    }
    .banner-input input[type="file"] {
        cursor: pointer;
        font-size: 20px;
        margin: 0;
        opacity: 0;
        overflow: hidden;
        padding: 0;
        position: absolute;
        right: 0;
        top: 0;
    }
    .banner-input-title {
        margin-left: 2px;
        overflow: hidden;
    }

    .logo-input {
        background-color: #2e4760;
        border-color: #2e4760;
        color: #fff;
        margin: 0;
        overflow: hidden;
        position: relative;
    }
    .logo-input input[type="file"] {
        cursor: pointer;
        font-size: 20px;
        margin: 0;
        opacity: 0;
        overflow: hidden;
        padding: 0;
        position: absolute;
        right: 0;
        top: 0;
    }
    .logo-input-title {
        margin-left: 2px;
        overflow: hidden;
    }

</style>
@endpush
@push('footerAssetPush')
<script src="{{ url('bassets/plugins/select2/select2.full.min.js') }}"></script>
<script src="{{ url('bassets/plugins/select2/select2.min.js') }}"></script>
<script type="application/javascript">
    $('.select2').select2();
    $(document).on('click', '#close-preview', function(){
        $('.banner').popover('hide');
        // Hover befor close the preview
        $('.banner').hover(
                function () {
                    $('.banner').popover('show');
                    $('.content').css('padding-bottom', '100px');
                },
                function () {
                    $('.banner').popover('hide');
                    $('.content').css('padding-bottom', '20px');
                }
        );
    });

    $(document).on('click', '#close-preview', function(){
        $('.logo').popover('hide');
        // Hover befor close the preview
        $('.logo').hover(
                function () {
                    $('.logo').popover('show');
                    $('.content').css('padding-bottom', '100px');
                },
                function () {
                    $('.logo').popover('hide');
                    $('.content').css('padding-bottom', '20px');
                }
        );
    });

    $(function() {
        // Create the close button
        var closebtn = $('<button/>', {
            type:"button",
            text: 'x',
            id: 'close-preview',
            style: 'font-size: initial;',
        });
        closebtn.attr("class","close pull-right");
        // Set the popover default content
        $('.banner').popover({
            trigger:'manual',
            html:true,
            title: "<strong>Preview</strong>"+$(closebtn)[0].outerHTML,
            content: "There's no image",
            placement:'right'
        });
        // Clear event
        $('.banner-clear').click(function(){
            $('.banner').attr("data-content","").popover('hide');
            $('.banner-filename').val("");
            $('.banner-clear').hide();
            $('.banner-input input:file').val("");
            $(".banner-input-title").text("File Browse");
        });
        // Create the preview image
        $(".banner-input input:file").change(function (){
            var img = $('<img/>', {
                id: 'dynamic',
                width:250,
                height:200,
                overflow:'hidden'
            });
            var file = this.files[0];
            var reader = new FileReader();
            // Set preview image into the popover data-content
            reader.onload = function (e) {
                $(".banner-input-title").text("File Browse");
                $(".banner-clear").show();
                $(".banner-filename").val(file.name);
                img.attr('src', e.target.result);
                $(".banner").attr("data-content",$(img)[0].outerHTML).popover("show");
                $('.content').css('padding-bottom', '100px');
            }
            reader.readAsDataURL(file);
        });

        $('.logo').popover({
            trigger:'manual',
            html:true,
            title: "<strong>Preview</strong>"+$(closebtn)[0].outerHTML,
            content: "There's no image",
            placement:'bottom'
        });
        // Clear event
        $('.logo-clear').click(function(){
            $('.logo').attr("data-content","").popover('hide');
            $('.logo-filename').val("");
            $('.logo-clear').hide();
            $('.logo-input input:file').val("");
            $(".logo-input-title").text("File Browse");
        });
        // Create the preview image
        $(".logo-input input:file").change(function (){
            var img = $('<img/>', {
                id: 'dynamic',
                width:250,
                height:200,
                overflow:'hidden'
            });
            var file = this.files[0];
            var reader = new FileReader();
            // Set preview image into the popover data-content
            reader.onload = function (e) {
                $(".logo-input-title").text("File Browse");
                $(".logo-clear").show();
                $(".logo-filename").val(file.name);
                img.attr('src', e.target.result);
                $(".logo").attr("data-content",$(img)[0].outerHTML).popover("show");
                $('.content').css('padding-bottom', '100px');
            }
            reader.readAsDataURL(file);
        });
    });

</script>
@endpush