<?php
/*
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net or labs.ini@gmail.com
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/
namespace Modules\Tax\Models\Traits\Attribute;

use Illuminate\Support\Facades\Auth;

trait TaxAttribute
{
    public function getEditButtonAttribute()
    {
        if(Auth::user()->hasPermission('admin@tax-edit')) {
            return '<a href="' . route('tax.edit', $this) . '" class="btn btn-xs btn-primary"><i class="fa fa-pencil" data-toggle="tooltip" data-placement="top" title="' . trans('Tax::tax.buttons.actions.edit') . '"></i></a> ';
        }
        return '';
    }

    public function getDeleteButtonAttribute()
    {
        if(Auth::user()->hasPermission('admin@tax-delete')) {
                return '<a href="' . route('tax.destroy', $this) . '"
                 data-method="delete"
                 data-trans-button-cancel="Cancel"
                 data-trans-button-confirm="Delete"
                 data-trans-title="Are you sure?"
                 class="btn btn-xs btn-danger tax-delete"><i class="fa fa-trash" data-toggle="tooltip" data-placement="top" title="' . trans('Tax::tax.buttons.actions.delete') . '"></i></a> ';
        }

        return "";
    }

    public function getStatusButtonAttribute()
    {
        if(Auth::user()->hasPermission('admin@tax-status')) {
            if ($this->status == 0)
                return "<a id=\"status\" class=\"btn btn-success btn-xs\" href=" . route('tax.status', $this) . " title='" . trans('Tax::tax.buttons.actions.status.active') . "'><i class='fa fa-play'></i></a> ";
            else
                return "<a id=\"status\" class=\"btn btn-danger btn-xs\" href=" . route('tax.status', $this) . " title='" . trans('Tax::tax.buttons.actions.status.deactive') . "'><i class='fa fa-pause'></i></a> ";
        }

    }

    public function getActionButtonsAttribute()
    {
        return
            $this->getEditButtonAttribute().
            $this->getStatusButtonAttribute().
            $this->getDeleteButtonAttribute();
    }
}