<?php
/*
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net or labs.ini@gmail.com
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/
Route::group(['Module' => 'Tax', 'prefix' => 'admin/tax', 'namespace' => '\Modules\Tax\Controllers', 'middleware' => ['web', 'installer', 'auth', 'acl']], function() {

    Route::get('/', 'TaxController@index')->name('tax.list');
    Route::get('list', 'TaxController@taxDataTable')->name('tax.list.datatable');

    Route::get('add', 'TaxController@add')->name('tax.create');
    Route::post('add', 'TaxController@create')->name('tax.create.post');

    Route::get('edit/{tax}', 'TaxController@edit')->name('tax.edit');
    Route::patch('edit/{tax}', 'TaxController@update')->name('tax.edit.post');

    Route::delete('delete/{tax}', 'TaxController@delete')->name('tax.destroy');
    Route::get('view/{tax}', 'TaxController@view')->name('tax.view');
    Route::get('status/{tax}', 'TaxController@status')->name('tax.status');

});
