<?php
/*
| -------------------------------------------------------------
| iBill - Simplest and Best Billing & Invoice Manager
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net
| -------------------------------------------------------------
| COPYRIGHT:        RESERVED BY INILABS IT
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/
namespace Modules\Todo\Models\Traits\Attribute;

use Illuminate\Support\Facades\Auth;

trait TodoAttribute
{
    public function getEditButtonAttribute()
    {
        if(Auth::user()->hasPermission('admin@todo-edit')) {
            return '<a href="' . route('todo.edit', $this) . '" class="btn btn-xs btn-primary"><i class="fa fa-pencil" data-toggle="tooltip" data-placement="top" title="' . trans('Todo::todo.buttons.actions.edit') . '"></i></a> ';
        }
    }
    public function getDeleteButtonAttribute()
    {
        if(Auth::user()->hasPermission('admin@todo-edit')) {
            if ($this->user_id == auth()->id()) {
                return '<a href="' . route('todo.destroy', $this) . '"
                 data-method="delete"
                 data-trans-button-cancel="Cancel"
                 data-trans-button-confirm="Delete"
                 data-trans-title="Are you sure?"
                 class="btn btn-xs btn-danger todo-delete"><i class="fa fa-trash" data-toggle="tooltip" data-placement="top" title="' . trans('Todo::todo.buttons.actions.delete') . '"></i></a> ';
            }
        }
        return "";
    }
    public function getActionButtonsAttribute()
    {
        return
            $this->getEditButtonAttribute().
            $this->getDeleteButtonAttribute();
    }

    public function getStatusButtonAttribute() {
        if(Auth::user()->hasPermission('admin@todo-status')) {
            if ($this->status == 1)
                return "<a id=\"status\" class=\"btn btn-success btn-xs\" href=" . route('todo.status', $this) . " title='" . trans('Todo::todo.buttons.actions.status') . "'><i class='fa fa-play'></i></a>";
            else
                return "<a id=\"status\" class=\"btn btn-danger btn-xs\" href=" . route('todo.status', $this) . " title='" . trans('Todo::todo.buttons.actions.status') . "'><i class='fa fa-pause'></i></a>";
        }

    }
}