<?php
/*
| -------------------------------------------------------------
| iBill - Simplest and Best Billing & Invoice Manager
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net
| -------------------------------------------------------------
| COPYRIGHT:        RESERVED BY INILABS IT
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/
namespace Modules\Todo\Requests;

use App\Http\Requests\Request;

class TodoRequest extends Request
{

    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        //$user = Iauth::find($this->segment(3));

        switch($this->method())
        {
            case 'GET':
            case 'DELETE':
            {
                return [];
            }
            case 'POST':
            {
                return [
                    'todo' => 'required|min:3'
                ];
            }
            case 'PUT':
            case 'PATCH':
            {
                return [
                    'todo' => 'required|min:3'
                ];
            }
            default:break;
        }
    }
}
