{{--{{ dd($roles) }}--}}
@if ($formFor == 'create')
    {!! Form::open(['class' => 'form-horizontal']) !!}
@elseif ($formFor == 'edit')
    {!! Form::model($todo, [
        'method' => 'PATCH',
        'route' => ['todo.edit.post', $todo->id],
        'class' => 'form-horizontal'
    ]) !!}
@endif
<div class="box-body">
    <div class="form-group{{ $errors->has('todo') ? ' has-error' : '' }}">
        {!! Form::label('todo', trans("Todo::todo.inputs.one"), ['class' => 'col-lg-2 control-label']) !!}
        <div class="col-lg-6">
            {!! Form::text('todo', null, ['class' => 'form-control', 'required' => 'required']) !!}
            {!! $errors->first('todo', '<span class="help-block">:message</span>') !!}
        </div>
    </div>
</div>
<div class="box box-info">
    <div class="box-body">
        <div class="form-group">
            <div class="col-sm-4 col-sm-offset-2">
                {{ link_to_route('todo.list', trans('Todo::todo.buttons.cancel'), [], ['class' => 'btn btn-danger']) }}
                {{ Form::submit($submitButton, ['class' => 'btn btn-primary hidden-xs']) }}
                {{ Form::submit($submitButton, ['class' => 'btn btn-primary visible-xs pull-right']) }}
            </div>
        </div>
        <div class="clearfix"></div>
    </div><!-- /.box-body -->
</div><!--box-->
{{ Form::close() }}