@extends('backend::pages.module')

@section('moduleTitle')
    <i class="fa fa-tasks"></i> {{ trans('Todo::todo.title') }}
@endsection
@section('moduleDescription')
    {{ trans('Todo::todo.optional_title.edit') }}
@endsection

@section('moduleBreadcrumb')
    <li><a href="{{ route('todo.list') }}"><i class="fa fa-tasks"></i>{{ trans('Todo::todo.breadcrumb.first') }}</a></li>
    <li class="active">{{ trans('Todo::todo.breadcrumb.edit') }}</li>
@endsection

@section('moduleContent')
    <div class="row">
        <div class="col-md-12">
            <div class="box box-success">
                <div class="box-header with-border">
                    <section class="content-header">
                        <h1 class="box-title">
                            @yield('moduleTitle', 'New Monule')
                            <small>@yield('moduleDescription', 'Optional description')</small>
                        </h1>
                        <ol class="breadcrumb">
                            @yield('moduleBreadcrumb', '
                                 <li><a href="#"><i class="fa fa-dashboard"></i> Level</a></li>
                                 <li class="active">Here</li>
                            ')
                        </ol>
                    </section>
                </div>
                @include('Todo::_form', ['submitButton' => trans('Todo::todo.buttons.update'), 'formFor' => 'edit', 'todo' => $todo])
            </div>
        </div>
    </div>
    <div class="clearfix"></div>
@endsection
