@extends('backend::pages.module')

@section('moduleTitle')
    <i class="fa fa-tasks"></i> {{ trans('Todo::todo.title') }}
@endsection
@section('moduleDescription')
    {{ trans('Todo::todo.optional_title.list') }}
@endsection

@section('moduleBreadcrumb')
    <li><a href="{{ route('todo.list') }}"><i class="fa fa-tasks"></i>{{ trans('Todo::todo.breadcrumb.first') }}</a></li>
    <li class="active">{{ trans('Todo::todo.breadcrumb.list') }}</li>
@endsection

@section('moduleContent')
    <div class="row">
        <div class="col-xs-12">
            <div class="box">
                <div class="box-header">
                    <section class="content-header">
                        <h1 class="box-title">
                            @yield('moduleTitle', 'New Monule')
                            <small>@yield('moduleDescription', 'Optional description')</small>
                        </h1>
                        <ol class="breadcrumb">
                            @yield('moduleBreadcrumb', '
                                 <li><a href="#"><i class="fa fa-dashboard"></i> Level</a></li>
                                 <li class="active">Here</li>
                            ')
                        </ol>
                    </section>
                </div><!-- /.box-header -->
                <div class="box-body">
                    @permission('admin@todo-add')
                    <a href="{{ route('todo.create') }}">
                        <button type="button" class="btn btn-flat margin-bottom" data-toggle="modal" data-target="#myModal">
                            <i class="fa fa-plus"></i>
                            {{ trans('Todo::todo.buttons.create') }}
                        </button>
                    </a>
                    @endpermission
                    <div id="hide-table">
                        <table id="todo-table" class="table table-striped table-bordered table-hover">
                            <thead>
                            <tr>
                                <th>#</th>
                                <th>{{ trans('Todo::todo.columns.one') }}</th>
                                <th>{{ trans('Todo::todo.columns.two') }}</th>
                                <th>{{ trans('Todo::todo.columns.three') }}</th>
                                <th>{{ trans('Todo::todo.columns.four') }}</th>
                            </tr>
                            </thead>
                        </table>
                    </div>
                </div><!-- /.box-body -->
            </div><!-- /.box -->
        </div>
    </div>
@endsection


@push('footerAssetPush')
<script type="application/javascript">
    // DataTable Load List Data
    $(function() {
        var t = $('#todo-table').DataTable( {
            "processing": true,
            "serverSide": true,
            "cache": true,
            "ajax": "{{ route("todo.list.datatable") }}",
            "columns": [
                {
                    "class":          "details-control",
                    "orderable":      false,
                    "data":           'id',
                    "defaultContent": ""
                },
                { "data": "todo" , "title" : "Todo"},
                { "data": "created_at" },
                { "data": "status" },
                { "data": "actions" }
            ],
            "order": [[1, 'asc']]
            // Per-row function to iterate cells
//            "createdRow": function (row, data, rowIndex) {
//                // Per-cell function to do whatever needed with cells
//                $.each($('td', row), function (colIndex) {
//                    // For example, adding data-* attributes to the cell
//                    $(this).attr('data-title', "foo");
//                });
//            }
        } );

        t.on( 'order.dt search.dt', function () {
            t.column(0, {search:'applied', order:'applied'}).nodes().each( function (cell, i) {
                cell.innerHTML = i+1;
            } );
        } ).draw();
    });
</script>
@endpush