<?php
/*
| -------------------------------------------------------------
| iBill - Simplest and Best Billing & Invoice Manager
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net
| -------------------------------------------------------------
| COPYRIGHT:        RESERVED BY INILABS IT
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/
Route::group(['Module' => 'Todo', 'prefix' => 'admin', 'namespace' => '\Modules\Todo\Controllers', 'middleware' => ['web', 'auth', 'acl']], function() {

    Route::group(['prefix' => 'todo'], function () {
        Route::get('/', 'TodoController@index')->name('todo.list');
        Route::get('list', 'TodoController@todoDataTable')->name('todo.list.datatable');

        Route::get('add', 'TodoController@add')->name('todo.create');
        Route::post('add', 'TodoController@create')->name('todo.create.post');

        Route::get('edit/{id}', 'TodoController@edit')->name('todo.edit');
        Route::patch('edit/{id}', 'TodoController@update')->name('todo.edit.post');

        Route::delete('delete/{id}', 'TodoController@delete')->name('todo.destroy');
        Route::get('status/{id}', 'TodoController@status')->name('todo.status');
    });

});
