@extends('backend::layouts.master')

@include('backend::pages.asset.dashHeaderAsset')

@section('content')
    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <section class="content-header">
            @include('flash::message')
        </section>
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1>
                Dashboard
                <small>Control panel</small>
            </h1>
            <ol class="breadcrumb">
                <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
                <li class="active">Dashboard</li>
            </ol>
        </section>

        <!-- Main content -->
        <section class="content">
            @role(1)
            <!-- Small boxes (Stat box) -->
            <div class="row">
                <div class="col-lg-3 col-xs-6">
                    <!-- small box -->
                    <div class="small-box bg-aqua">
                        <div class="inner">
                            <h3>{{ $users }}</h3>

                            <p>{{ trans('Iauth::dashboard.wid_user') }}</p>
                        </div>
                        <div class="icon">
                            <i class="fa fa-user"></i>
                        </div>
                        {{--<a href="#" class="small-box-footer">More info <i class="fa fa-arrow-circle-right"></i></a>--}}
                    </div>
                </div>
                <!-- ./col -->
                <div class="col-lg-3 col-xs-6">
                    <!-- small box -->
                    <div class="small-box bg-green">
                        <div class="inner">
                            <h3>{{ $roles }}</h3>

                            <p>{{ trans('Iauth::dashboard.wid_role') }}</p>
                        </div>
                        <div class="icon">
                            <i class="fa fa-users"></i>
                        </div>
                        {{--<a href="#" class="small-box-footer">More info <i class="fa fa-arrow-circle-right"></i></a>--}}
                    </div>
                </div>
                <!-- ./col -->
                @endrole
                <div class="@role(1) col-md-3 col-sm-6 col-xs-12 @else col-md-6 col-sm-12 col-xs-12 @endrole">
                    <!-- small box -->
                    <div class="small-box bg-yellow">
                        <div class="inner">
                            <h3>{{ $notices }}</h3>

                            <p>{{ trans('Iauth::dashboard.wid_notice') }}</p>
                        </div>
                        <div class="icon">
                            <i class="fa fa-bell"></i>
                        </div>
                        {{--<a href="#" class="small-box-footer">More info <i class="fa fa-arrow-circle-right"></i></a>--}}
                    </div>
                </div>
                <!-- ./col -->
                <div class="@role(1) col-md-3 col-sm-6 col-xs-12 @else col-md-6 col-sm-12 col-xs-12 @endrole">
                    <!-- small box -->
                    <div class="small-box bg-red">
                        <div class="inner">
                            @if(config('core.havefrontend'))
                                <h3 class="info-box-number">{{ $posts }}</h3>
                                <p class="info-box-text">{{ trans('Iauth::dashboard.wid_post') }}</p>
                            @else
                                <h3>{{ $todos->count() }}</h3>
                                <p class="info-box-text">{{ trans('Iauth::dashboard.wid_todo') }}</p>
                            @endif
                        </div>
                        <div class="icon">
                            <i class="ion ion-pie-graph"></i>
                        </div>
                        {{--<a href="#" class="small-box-footer">More info <i class="fa fa-arrow-circle-right"></i></a>--}}
                    </div>
                </div>
                <!-- ./col -->
            </div>
            <!-- /.row -->
            <!-- Main row -->
            <div class="row">
                @role(1)
                <!-- Left col -->
                <section class="col-lg-7 connectedSortable">
                    <!-- Chat box -->
                    <div class="box box-success">
                        <div class="box-header">
                            <i class="fa fa-comments-o"></i>
                            <h3 class="box-title">{{ trans('Iauth::dashboard.activity_log') }}</h3>
                            <div class="box-tools pull-right" data-toggle="tooltip" title="Status">
                                <div class="btn-group" data-toggle="btn-toggle">
                                    <button type="button" class="btn btn-default btn-sm active"><i class="fa fa-square text-green"></i>
                                    </button>
                                    <button type="button" class="btn btn-default btn-sm"><i class="fa fa-square text-red"></i></button>
                                </div>
                            </div>
                        </div>
                        <div class="box-body chat" id="chat-box">
                            {!! history()->render() !!}
                        </div>
                        <!-- /.chat -->
                    </div>
                    <!-- /.box (chat box) -->


                    <!-- /.box -->
                </section>
                <!-- /.Left col -->
                @endrole
                @permission('admin@todo')
                <!-- right col (We are only adding the ID to make the widgets sortable)-->
                <section class="@role(1) col-lg-5 @else col-lg-12 @endrole connectedSortable">
                    <!-- TO DO List -->
                    <div class="box box-primary">
                        <div class="box-header">
                            <i class="ion ion-clipboard"></i>
                            <h3 class="box-title">{{ trans('Iauth::dashboard.todo_list') }}</h3>
                        </div>
                        <!-- /.box-header -->
                        <div class="box-body">
                            <ul class="todo-list">
                                {{--{{ dd($todos) }}--}}
                                <?php $colors = ['danger', 'success', 'warning', 'primary', 'info'] ?>
                                @foreach($todos as $todo)
                                    <li {{ $todo->status == 1 ?  "class=done" : ""  }}>
                                        <!-- drag handle -->
                                        <span class="handle">
                                        <i class="fa fa-ellipsis-v"></i>
                                        <i class="fa fa-ellipsis-v"></i>
                                    </span>
                                        <!-- checkbox -->
                                        <a href="{{ route('todo.status', $todo) }}"><input {{ $todo->status == 1 ?  "checked" : ""  }} type="checkbox" value=""></a>
                                        <!-- todo text -->
                                        <span class="text">{{ $todo->todo }}</span>
                                        <!-- Emphasis label -->
                                        <small class="label label-{{ $colors[rand(1,1000) % 5] }}"><i class="fa fa-clock-o"></i> {{ $todo->created_at->diffForHumans() }}</small>
                                        <!-- General tools such as edit or delete-->
                                        <div class="tools">
                                            <a href="{{ route('todo.edit', $todo) }}"><i class="fa fa-edit "></i></a>
                                            <a href="{{route('todo.destroy', $todo)}}"
                                               data-method="delete"
                                               data-trans-button-cancel="Cancel"
                                               data-trans-button-confirm="Delete"
                                               data-trans-title="Are you sure?"
                                               class="todo-delete"><i class="fa fa-trash-o text-danger" data-toggle="tooltip" data-placement="top" title="{{  trans('Todo::todo.buttons.actions.delete') }}"></i></a>
                                        </div>
                                    </li>
                                @endforeach
                            </ul>
                        </div>
                        <!-- /.box-body -->
                        <div class="box-footer clearfix no-border">
                            <a href="{{ route('todo.create') }}" type="button" class="btn btn-default pull-right"><i class="fa fa-plus"></i> {{ trans('Iauth::dashboard.todo_add') }}</a>
                        </div>
                    </div>
                    <!-- /.box -->

                </section>
                <!-- right col -->
                @endpermission
            </div>
            <!-- /.row (main row) -->
            <div class="row">
                <div class="col-lg-12">
                    <div class="box box-success">
                        <div class="box-header">{{ trans('Iauth::dashboard.calender') }}</div>
                        <div class="box-body" >
                            <div id='calendar'></div>
                        </div>
                    </div>
                </div>
            </div>

        </section>
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->
    @include('backend::pages.asset.dashFooterAsset')
@endsection