@extends('backend::layouts.login')

@section('bodyClass')
    register-page
@endsection

@section('boxAfterBody')
    register-box
@endsection

@include('backend::pages.asset.loginAndRegistrationHeaderAsset')

@section('content')
    <div class="register-logo">
        <a href="{{ route('admin.login') }}">{!! isite()->siteName() !!} </a>
    </div>
    @include('flash::message')
    <div class="register-box-body">
        <p class="login-box-msg">{!! trans("Iauth::login.signip_title") !!}</p>
        <form method="POST" action="{{ route('admin.register.post') }}">
            {!! csrf_field() !!}

            <div class="form-group{{ $errors->has('username') ? ' has-error' : '' }} has-feedback">
                <input type="text" class="form-control" placeholder="Username" name="username" value="{{ old('username') }}">
                <span class="glyphicon glyphicon-user form-control-feedback"></span>
                @if ($errors->has('username'))
                    <span class="help-block">
                        <strong>{{ $errors->first('username') }}</strong>
                    </span>
                @endif
            </div>

            <div class="form-group{{ $errors->has('email') ? ' has-error' : '' }} has-feedback">
                <input type="email" class="form-control" placeholder="Email" name="email" value="{{ old('email') }}">
                <span class="glyphicon glyphicon-envelope form-control-feedback"></span>
                @if ($errors->has('email'))
                    <span class="help-block">
                        <strong>{{ $errors->first('email') }}</strong>
                    </span>
                @endif
            </div>

            <div class="form-group{{ $errors->has('password') ? ' has-error' : '' }} has-feedback">
                <input type="password" class="form-control" placeholder="Password" name="password">
                <span class="glyphicon glyphicon-lock form-control-feedback"></span>

                @if ($errors->has('password'))
                    <span class="help-block">
                        <strong>{{ $errors->first('password') }}</strong>
                    </span>
                @endif
            </div>

            <div class="form-group{{ $errors->has('password_confirmation') ? ' has-error' : '' }} has-feedback">
                <input type="password" class="form-control" placeholder="Retype password" name="password_confirmation">
                <span class="glyphicon glyphicon-log-in form-control-feedback"></span>
                @if ($errors->has('password_confirmation'))
                    <span class="help-block">
                        <strong>{{ $errors->first('password_confirmation') }}</strong>
                    </span>
                @endif
            </div>
            <div class="row">
                <div class="col-xs-8">
                    <div class="checkbox icheck">
                        <label>
                            <input type="checkbox" required> {{ trans("Iauth::login.terms") }}
                        </label>
                    </div>
                </div><!-- /.col -->
                <div class="col-xs-4">
                    <button type="submit" class="btn btn-primary btn-block btn-flat">{{ trans("Iauth::login.signup") }}</button>
                </div><!-- /.col -->
            </div>
        </form>

        <div class="social-auth-links text-center">
            <p>- {{ trans('Iauth::login.signinor') }} -</p>
            <a href="{{ route('login.social','facebook') }}" class="btn btn-facebook"><i class="fa fa-facebook"></i></a>
            <a href="{{ route('login.social', 'google') }}" class="btn btn-google"><i class="fa fa-google-plus"></i></a>
            <a href="{{ route('login.social','github') }}" class="btn btn-github"><i class="fa fa-github"></i></a>
        </div>

        <a href="{{ route('admin.login') }}" class="text-center">{{ trans('Iauth::login.already_registered') }}</a>
    </div>
    <!-- /.form-box -->
    @include('backend::pages.asset.loginAndRegistrationFooterAsset')
@endsection