@extends('backend::layouts.login')

@include('backend::pages.asset.loginAndRegistrationHeaderAsset')

@section('content')
    <div class="login-logo">
        <a href="{{ url('admin') }}">{!! isite()->siteName() !!}</a>
    </div><!-- /.login-logo -->
    @include('flash::message')
    <div class="box remove-border">
	    <div class="box-header with-border skin-black">
	      {!! trans("Iauth::login.signin_title") !!}
	    </div>
      <div class="box-body">
      <!-- <div class="login-box-body"> -->
          <form method="POST" action="{{ route('admin.login.post') }}">

              {!! csrf_field() !!}

              <div class="form-group{{ $errors->has('emailorusername') ? ' has-error' : '' }} has-feedback">
                  <input type="text" class="form-control pl" placeholder="Username or Email" name="emailorusername" value="{{ old('emailorusername') }}">
                  <span class="fa fa-envelope-o form-control-feedback"></span>
                  @if ($errors->has('emailorusername'))
                      <span class="help-block">
                       <strong>{{ $errors->first('emailorusername') }}</strong>
                   </span>
                  @endif
              </div>

              <div class="form-group{{ $errors->has('password') ? ' has-error' : '' }} has-feedback">
                  <input type="password" class="form-control pl" placeholder="Password" name="password">
                  <span class="fa fa-key form-control-feedback"></span>

                  @if ($errors->has('password'))
                      <span class="help-block">
                       <strong>{{ $errors->first('password') }}</strong>
                   </span>
                  @endif
              </div>
              <div class="row">
    		        <div class="col-xs-7">
    		          <div class="checkbox icheck">
    		            <label>
    		            	<input type="checkbox" class="flat-red"> {{ trans("Iauth::login.remember") }}
    		            </label>
    		          </div>
    		        </div>
    		        <div class="col-xs-5">
    		         	<a href="{{ route('admin.password.reset') }}" class="forget-label">{{ trans("Iauth::login.forget_password") }}</a>
    		        </div>

    		        <!-- /.col -->
    		        <div class="col-xs-12">
    		          <button type="submit" class="btn btn-primary btn-block btn-flat btn-lg">{{ trans("Iauth::login.signin") }}</button>
    		        </div>
    		        <!-- /.col -->
              </div>
          </form>

          @if(config('core.demosite'))
              @include('backend::partials.demoLoginAccess')
          @endif
          <div class="social-auth-links text-center">
              <a href="http://inilabs.net" ><img src="{{ url(config('core.assets_path.image').'backend/inilabs.png') }}" width="200"></a>
          </div>
      </div>
   </div>
    <!-- /.login-box-body -->
    @include('backend::pages.asset.loginAndRegistrationFooterAsset')
@endsection
