<header class="main-header">
    <!-- Logo -->
    <a href="{{ url('/admin') }}" class="logo">
        <!-- mini logo for sidebar mini 50x50 pixels -->
        <span class="logo-mini">{!! get_isite_sitesortname() !!}</span>
        <!-- logo for regular state and mobile devices -->
        <span class="logo-lg">{!! get_isite_sitename() !!}</span>
    </a>
    <!-- Header Navbar: style can be found in header.less -->
    <nav class="navbar navbar-static-top">
        <!-- Sidebar toggle button-->
        <a href="#" class="sidebar-toggle" data-toggle="offcanvas" role="button">
            <span class="sr-only">Toggle navigation</span>
        </a>
        {{-- Left side top menu --}}
        @role('Admin')
        <div class="cd-dropdown-wrapper hidden-xs">
                <a class="cd-dropdown-trigger bg-primary" href="#0">Quick Links</a>
                <nav class="cd-dropdown">
                    <h2>Title</h2>
                    <a href="#0" class="cd-close">Close</a>
                    <ul class="cd-dropdown-content">
                        <li class="has-children">
                            <a href="#">Create</a>

                            <ul class="cd-secondary-dropdown is-hidden">
                                <li class="has-children">
                                    <a href="#">{{ trans('Client::client.quick_menu') }}</a>

                                    <ul class="is-hidden">
                                        <li><a href="{{ route('client.create') }}">{{ trans('Client::client.quick_menu') }}</a></li>
                                        <li><a href="{{ route('invoice.create') }}">{{ trans('Invoice::invoice.title') }}</a></li>
                                        <li><a href="{{ route('quotation.create') }}">{{ trans('Quotation::quotation.title') }}</a></li>
                                    </ul>
                                    <a href="#">{{ trans('Client::client.main_menu_user_management') }}</a>

                                    <ul class="is-hidden">
                                        <li><a href="{{ route('user.add') }}">{{ trans('Iauth::user.title') }}</a></li>
                                        <li><a href="{{ route('role.add') }}">{{ trans('Iauth::role.title') }}</a></li>
                                        <li><a href="{{ route('permission.assign') }}">{{ trans('Core::menu.backendMenu.permissionAssign') }}</a></li>
                                    </ul>
                                </li>

                                <li class="has-children">
                                    <a href="#">{{ trans('ExpenseType::expensetype.main_menu') }}</a>

                                    <ul class="is-hidden">
                                        <li><a href="{{ route('expensetype.create') }}">{{ trans('ExpenseType::expensetype.module') }}</a></li>
                                        <li><a href="{{ route('paymenttype.create') }}">{{ trans('PaymentType::paymenttype.module') }}</a></li>
                                    </ul>
                                </li>

                                <li class="has-children">
                                    <a href="#">Others</a>

                                    <ul class="is-hidden">
                                        <li><a href="{{ route('inbox.message') }}">{{ trans('Core::menu.backendMenu.message') }}</a></li>
                                        <li><a href="{{ route('notice.create') }}">{{ trans('Core::menu.backendMenu.notice') }}</a></li>
                                        <li><a href="{{ route('todo.create') }}">{{ trans('Core::menu.backendMenu.todo') }}</a></li>
                                        <li><a href="{{ route('plugin.upload') }}">{{ trans('Core::menu.backendMenu.extension') }}</a></li>
                                        <li><a href="{{ route('lang') }}">{{ trans('Core::menu.backendMenu.lang') }}</a></li>
                                        <li><a href="{{ route('export.create') }}">{{ trans('Core::menu.backendMenu.export') }}</a></li>
                                        <li><a href="{{ route('settings') }}">{{ trans('Core::menu.backendMenu.settings') }}</a></li>
                                    </ul>
                                </li>

                                <li class="has-children">
                                    <a href="#">Sales</a>

                                    <ul class="is-hidden">
                                        <li><a href="{{ route('expense.create') }}">{{ trans('Expense::expense.module') }}</a></li>
                                        <li><a href="{{ route('product.create') }}">{{ trans('Product::product.module') }}</a></li>
                                        <li><a href="{{ route('tax.create') }}">{{ trans('Tax::tax.module') }}</a></li>
                                    </ul>
                                </li>
                            </ul> <!-- .cd-secondary-dropdown -->
                        </li> <!-- .has-children -->


                        <li class="has-children">
                            <a href="#">Services</a>
                            <ul class="cd-dropdown-icons is-hidden">
                                <li class="go-back"><a href="#0">Menu</a></li>
                                <li>
                                    <a class="cd-dropdown-item item-1" href="{{ route('invoice.list') }}">
                                        <h3>{{ trans('Invoice::invoice.module') }} #1</h3>
                                        <p>Manage All Invoice List</p>
                                    </a>
                                </li>

                                <li>
                                    <a class="cd-dropdown-item item-2" href="{{ route('quotation.list') }}">
                                        <h3>{{ trans('Quotation::quotation.module') }} #2</h3>
                                        <p>Manage All Quotation List</p>
                                    </a>
                                </li>

                                <li>
                                    <a class="cd-dropdown-item item-3" href="{{ route('client.list') }}">
                                        <h3>{{ trans('Client::client.module') }} #3</h3>
                                        <p>Manage All Clients List</p>
                                    </a>
                                </li>

                                <li>
                                    <a class="cd-dropdown-item item-4" href="{{ route('expense.list') }}">
                                        <h3>{{ trans('Expense::expense.module') }} #4</h3>
                                        <p>Manage All Expense List</p>
                                    </a>
                                </li>

                                <li>
                                    <a class="cd-dropdown-item item-5" href="{{ route('product.list') }}">
                                        <h3>{{ trans('Product::product.module') }} #5</h3>
                                        <p>Manage All Expense List</p>
                                    </a>
                                </li>

                                <li>
                                    <a class="cd-dropdown-item item-6" href="{{ route('notice.list') }}">
                                        <h3>{{ trans('Notice::notice.module') }} #5</h3>
                                        <p>Manage All Notice List</p>
                                    </a>
                                </li>

                                <li>
                                    <a class="cd-dropdown-item item-7" href="{{ route('tax.list') }}">
                                        <h3>{{ trans('Tax::tax.module') }} #5</h3>
                                        <p>Manage All Tax List</p>
                                    </a>
                                </li>

                                <li>
                                    <a class="cd-dropdown-item item-8" href="{{ route('export.create') }}">
                                        <h3>{{ trans('Settings::settings.module') }} #5</h3>
                                        <p>Manage All Settings List</p>
                                    </a>
                                </li>

                            </ul> <!-- .cd-dropdown-icons -->
                        </li> <!-- .has-children -->
                    </ul> <!-- .cd-dropdown-content -->
                </nav> <!-- .cd-dropdown -->
            </div> <!-- .cd-dropdown-wrapper -->
        @endrole
        {{-- right side top menu --}}
        <div class="navbar-custom-menu">
            <ul class="nav navbar-nav">
                @if(config('core.demosite'))
                    <li class="dropdown messages-menu">
                        <a href="https://codecanyon.net/item/ibill-simplest-and-best-billing-invoice-manager/19401793?ref=inilabs"  target="_blank">
                            <i title="Buy Now" class="fa fa-shopping-cart set-size" ></i>
                        </a>
                    </li>
                @endif
                <li class="dropdown notifications-menu">
                    <a href="javascript:void(0)" class="dropdown-toggle noticealert" data-toggle="dropdown" data-user="{{ auth()->user()->id }}">
                        <i class="fa fa-bell-o set-size"></i>
                        @if(!session()->has('notice-button-click') || (session()->has('notice-button-click') &&  session('notice-button-click'))) <span class="label label-warning">{{ get_notice_alert_count() }}</span> @endif
                    </a>
                    <ul class="dropdown-menu animated bounceInDown">
                        <li class="header">{{ trans('Notice::notice.other.unreadNotice', ['count' => get_notice_alert_count()]) }}</li>
                        <li>
                            <!-- inner menu: contains the actual data -->
                            <ul class="menu">
                                @foreach(site()->notice('noticeAlert')->getAllNotice() as $notice)
                                    <li class="{{ isset($notice->seen()[$notice->id]) ? '' : 'text-bold bg-gray-light' }}">
                                        <a href="{{ route('notice.view', $notice) }}">
                                            <i class="fa fa fa-bullhorn"></i> {{ $notice->title }}
                                        </a>
                                    </li>
                                @endforeach
                            </ul>
                        </li>
                        <li class="footer"><a href="{{ route('notice.list') }}">View all</a></li>
                    </ul>
                </li>
                {{--Language bar--}}
                @if (( config('locale.status') && count(config('locale.languages')) > 1) && (!config('locale.browser_locale') && !config('locale.geoIP_locale')))
                <li class="dropdown messages-menu">
                    <a href="#" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-expanded="false">
                        <img class="language-img set-size" src="{{ url(config('core.assets_path.lang_image').App::getLocale().'.png') }}">
                        <span class="label label-danger">{{ count(config('locale.languages')) }}</span>
                    </a>
                    @include('backend::partials.lang')
                </li>
                @endif
                <!-- Lang end -->
                <!-- User Account: style can be found in dropdown.less -->
                <li class="dropdown user user-menu">
                    <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                        <img src="{{ url(auth()->user()->img) }}" class="user-image" alt="{{ auth()->user()->name }}">
                        @if(auth()->user()->first_name)
                            <span class="hidden-xs">{{ auth()->user()->name}}</span>
                        @else
                            <span class="hidden-xs">{{ auth()->user()->username }}</span>
                        @endif
                    </a>
                    <ul class="dropdown-menu animated flipInY">
                        <!-- User image -->

                        <li><a href="{{ route('profile') }}"><i class="fa fa-suitcase"></i> {{ trans('Iauth::backendLinks.topbar.profile') }}</a></li>
                        @role('Admin')
                            <li><a href="{{ route('settings') }}"><i class="fa fa-cog"></i> {{ trans('Iauth::backendLinks.topbar.settings') }}</a></li>
                        @endrole
                        <li><a href="{{ route('notice.list') }}"><i class="fa fa-bell-o"></i>  {{ trans('Iauth::backendLinks.topbar.notifications') }}</a></li>
                        <li><a href="{{ route('user.change-profile-password') }}"><i class="fa fa-lock"></i>  {{ trans('Iauth::backendLinks.topbar.password') }}</a></li>
                        <li class="logout"><a href="{{ route('backend.logout') }}"><i class="fa fa-key"></i> {{ trans('Iauth::backendLinks.topbar.logout') }}</a></li>
                    </ul>
                </li>
                <!-- Control Sidebar Toggle Button -->
                <li>
                    {{--<a href="#" data-toggle="control-sidebar"><i class="fa fa-gears"></i></a>--}}
                </li>
            </ul>
        </div>
    </nav>
</header>

@push('footerAssetPush')
<script>
    $('a[data-user]').click(function($e){
        $e.preventDefault();
        $.ajax({
            method: 'GET',
            url: '{{ route('notice.button.click') }}',
            data: {userID : $(this).data('user')},
            success: function (data) {
                $('.noticealert span').remove();
            }
        });
    });
</script>
@endpush

