<?php

namespace App\Http\Middleware;

use Closure, Theme;
use Core\iSite;
use Illuminate\Support\Facades\Auth;

class Authenticate
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @param  string|null  $guard
     * @return mixed
     */
    public function handle($request, Closure $next, $guard = null)
    {
        $explodeUrl = explode('/', $request->path());

        if (Auth::guard($guard)->guest()) {
            if ($request->ajax() || $request->wantsJson()) {
                return response('Unauthorized.', 401);
            } elseif(Theme::getHaveFrontend() && $explodeUrl[0] != 'admin') {
                return $next($request);
            } else {
                return redirect()->guest(route('admin.login'));

            }
        } elseif(!Theme::getHaveFrontend() && $explodeUrl[0] == '') {
            return redirect()->route('backend.root');
        }
        return $next($request);
    }
}
