<?php

namespace App\Http\Middleware;

use Closure;

class HasPermission
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  \Closure                 $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        $explodeUrl         = explode('/',$request->path());
        $countExplodeUrl    = count($explodeUrl);

        $requestUrl         = $explodeUrl[0];
        $f                  = true;

        if($requestUrl == 'admin') {
            $requestUrl .= '@';
            $f          = false;
        }

        for ($i = 1; $i < $countExplodeUrl; $i++) {
            if(!is_numeric($explodeUrl[$i]) && $f) {
                $requestUrl     .=  '-'.$explodeUrl[$i];
            } elseif(!$f) {
                $requestUrl     .=  $explodeUrl[$i];
                $f              =   true;
            }
        }

        if(is_numeric(strpos($requestUrl, 'admin@user-view'))) {
            $requestUrl = 'admin@user-view';
        }

        if(is_numeric(strpos($requestUrl, 'admin@post-view'))) {
            $requestUrl = 'admin@post-view';
        }
//        dd(strpos($requestUrl, 'admin@user-view'));
//        dd($requestUrl);
//        $requestUrl = $request->segment(1);
//
//        if($request->segment(2)) {
//            $requestUrl = $requestUrl.'-'.$request->segment(2);
//        }

        $getAllPermission = $this->getThisUserPermissions($request->user()->roles);

        if(in_array($requestUrl,$getAllPermission)) {
            return $next($request);
        }

        return abort(404, 'Permission Denied ...!!!');
    }

    protected function getThisUserPermissions($roles)
    {
        $permissions = [];
        foreach ($roles as $role){
            $permissions[] = $role->permissions->pluck('name')->all();
        }

        return array_unique(array_reduce($permissions, 'array_merge', array()));
    }

}
