
<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('users', function (Blueprint $table) {
            $table->increments('id');
            $table->string('username')->unique()->nullable();
            $table->string('first_name')->nullable();
            $table->string('last_name')->nullable();
            $table->string('email')->unique();
            $table->string('email_text')->nullable();
            $table->date('dob')->nullable();
            $table->string('password', 60)->nullable();
            $table->string('img')->nullable();
            $table->string('gender')->nullable();
            $table->string('phone')->nullable();
            $table->string('about')->nullable();
            $table->tinyInteger('status')->default(1);
            $table->string('confirmation_code');
            $table->boolean('is_valid_email')->default(config('core.users.is_valid_email') ? false : true);
            $table->integer('is_valid_phone')->default(config('core.users.is_valid_phone') ? false : true);
            $table->rememberToken();
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('users');
    }
}
