<?php

use Illuminate\Database\Seeder;
use Modules\Expense\Models\Expense;
use Modules\Iauth\Models\Access\User\User;
use Carbon\Carbon;
class ExpenseTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $faker = Faker\Factory::create();
        $users = User::all()->pluck('id')->take(5)->toArray();
        $payment_types = \Modules\PaymentType\Models\PaymentType::all()->pluck('id')->toArray();
        $expense_types = \Modules\ExpenseType\Models\ExpenseType::all()->pluck('id')->toArray();

        for ($i=0; $i <= 12; $i++) {
            $expense = new Expense;
            $expense->title = $faker->sentence();
            $expense->note = $faker->sentence(4);
            $expense->user_id = 1;
            $expense->purchased_id = $faker->randomElement($users);
            $expense->purchased_date = Carbon::createFromTimeStamp($faker->dateTimeBetween('-30 days', '+1 years')->getTimestamp());
            $expense->created_at = Carbon::createFromTimeStamp($faker->dateTimeBetween('-30 days', '+1 years')->getTimestamp());
            $expense->purchased_amount = $faker->biasedNumberBetween( 1, 1000);
            $expense->payment_type_id  = $faker->randomElement($payment_types);
            $expense->expense_type_id  = $faker->randomElement($expense_types);
            $expense->save();
        };
    }
}
