<?php

use Illuminate\Database\Seeder;
use Modules\Invoice\Models\Invoice;
use Carbon\Carbon;

class   InvoicesTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        //faker new instance
        $faker = Faker\Factory::create();

        $clients = \Modules\Client\Models\Client::all()->pluck('user_id')->toArray();
        $payment_types = \Modules\PaymentType\Models\PaymentType::all()->pluck('id')->toArray();
        $currencies = Modules\Currency\Models\Currency::all()->pluck('id')->toArray();
        $payment_status = 'unpaid';

        foreach ($clients as $client) {
            for ($k = 1; $k <= 1; $k++) {
                $invoice = new Invoice;
                $invoice->client_id = $client;
                $invoice->token = "token_".mt_rand(100000, 999999);
                $invoice->currency_id = $faker->randomElement($currencies);
                $invoice->user_id = 1;
                $invoice->serial = str_random(7);
                $invoice->paymenttype_id = $faker->randomElement($payment_types);
                $invoice->payment_status = $payment_status;
                $invoice->create_date = Carbon::createFromTimeStamp($faker->dateTimeBetween('-30 days', '+1 years')->getTimestamp());
                $invoice->created_at = Carbon::createFromTimeStamp($faker->dateTimeBetween('-30 days', '+1 years')->getTimestamp());
                $invoice->due_date = Carbon::createFromTimeStamp($faker->dateTimeBetween('-30 days', '+1 years')->getTimestamp());
                $invoice->note = $faker->sentence(5);
                $invoice->terms_conditions = $faker->sentence(5);
                $invoice->sub_total = 6000;
                $invoice->grand_total = 6000;
                $invoice->save();

                for ($i = 1; $i <= 3; $i++) {
                    $products = new \Modules\Invoice\Models\OrderItem;
                    $products->invoice_id = $invoice->id;
                    $products->name = $faker->word;
                    $products->quantity = 2;
                    $products->price = '1000';
                    $products->total = $products->quantity*$products->price;
                    $products->save();
                }
            }
        }

    }
}
