<?php

use Illuminate\Database\Seeder;
use Modules\Invoice\Models\Payment;
use Carbon\Carbon;

class PaymentTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        //faker new instance
        $faker = Faker\Factory::create();
        $payment_types = \Modules\PaymentType\Models\PaymentType::all()->pluck('name')->toArray();
        $settings =  \Modules\Settings\Models\Settings::all()->pluck('value', 'option')->toArray();
        $invoices = \Modules\Invoice\Models\Invoice::all();

        foreach ($invoices as $invoice) {
            if ((int)$invoice->id % 2 === 0) {
                $paid_amount = $faker->biasedNumberBetween( 1, $invoice->grand_total);
                $updateinvoice = \Modules\Invoice\Models\Invoice::find($invoice->id);
                $updateinvoice->payment_status = 'partially paid';
                $updateinvoice->save();
            } else {
                $paid_amount = $invoice->grand_total;
                $updateinvoice = \Modules\Invoice\Models\Invoice::find($invoice->id);
                $updateinvoice->payment_status = 'paid';
                $updateinvoice->save();
            }
            $payment = new Payment;
            $payment->invoice_id = $invoice->id;
            $payment->user_id = $invoice->client_id;
            $payment->transaction_id = str_random(16);
            $payment->currency_code = $settings['site_currency_code'];
            $payment->paid_amount  = $paid_amount;
            $payment->payment_status  = "Complete";
            $payment->payment_type  = $faker->randomElement($payment_types);
            $payment->paid_date  = Carbon::createFromTimeStamp($faker->dateTimeBetween('-30 days', '+1 years')->getTimestamp());
            $payment->created_at = Carbon::createFromTimeStamp($faker->dateTimeBetween('-30 days', '+1 years')->getTimestamp());
            $payment->save();
        }

    }
}
