<?php

use Illuminate\Database\Seeder;
use Modules\Quotation\Models\Quotation;

class QuotationsTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        //faker new instance
        $faker = Faker\Factory::create();

        $clients = \Modules\Client\Models\Client::all()->pluck('user_id')->toArray();
        $currencies = Modules\Currency\Models\Currency::all()->pluck('id')->toArray();

        foreach ($clients as $client) {
            for ($k = 1; $k <= 2; $k++) {
                $quotation = new Quotation;
                $quotation->client_id = $client;
                $quotation->currency_id = $faker->randomElement($currencies);
                $quotation->user_id = 1;
                $quotation->serial = str_random(7);
                $quotation->note = $faker->sentence(5);
                $quotation->terms_conditions = $faker->sentence(5);
                $quotation->sub_total = 3000;
                $quotation->grand_total = 3000;
                $quotation->save();

                for ($i = 1; $i <= 3; $i++) {
                    $products = new \Modules\Quotation\Models\QuotationItem;
                    $products->quotation_id = $quotation->id;
                    $products->name = $faker->word;
                    $products->quantity = 2;
                    $products->price = '500';
                    $products->total = $products->quantity*$products->price;
                    $products->save();
                }
            }
        }

    }
}
