<?php

use Illuminate\Database\Seeder;
use Modules\Iauth\Repositories\Access\Permission\PermissionRepositoryContract;
use Modules\History\Models\History\HistoryType;

class RolesPermissionsHistoryAndDefaultUserTableSeeder extends Seeder
{
    protected $permissionRepo;

    public function __construct(PermissionRepositoryContract $permission)
    {
        $this->permissionRepo = $permission;
    }
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $this->auto();
        $historyTypes = ['User', 'Role', 'Notice', 'Todo', 'Post'];
        foreach ($historyTypes as $historyType) {
            HistoryType::create(['name' => $historyType]);
        }

        $role   = Config::get('installer.role');
        $data   = [
            ['name'=> 'Admin', 'all'=> 0, 'sort' => 1],
            ['name'=> 'User', 'all'=> 0, 'sort' => 2],
            ['name'=> 'Client', 'all'=> 0, 'sort' => 3]
        ];

        $adminID    = $role::create($data[0]);
        $userID     = $role::create($data[1]);
        $clientID     = $role::create($data[2]);

        $pemission      = Config::get('installer.permission');
        $allPermission  = $pemission::where('status', '=', 1)->get()->pluck('id', 'name')->all();

        $adminID->attachPermissions(array_values($allPermission));

        $userPermission[] = $allPermission['admin@notice-view'];
        $userPermission[] = $allPermission['admin@todo'];
        $userPermission[] = $allPermission['admin@todo-list'];
        $userPermission[] = $allPermission['admin@todo-add'];
        $userPermission[] = $allPermission['admin@todo-edit'];
        $userPermission[] = $allPermission['admin@todo-delete'];
        $userPermission[] = $allPermission['admin@todo-status'];

        $userID->attachPermissions($userPermission);

        $clientPermission[] = $allPermission['admin@notice-view'];
        $clientPermission[] = $allPermission['admin@todo'];
        $clientPermission[] = $allPermission['admin@todo-list'];
        $clientPermission[] = $allPermission['admin@todo-add'];
        $clientPermission[] = $allPermission['admin@todo-edit'];
        $clientPermission[] = $allPermission['admin@todo-delete'];
        $clientPermission[] = $allPermission['admin@todo-status'];
        $clientPermission[] = $allPermission['admin@notice'];
        $clientPermission[] = $allPermission['admin@notice-list'];
        $clientPermission[] = $allPermission['admin@invoice'];
        $clientPermission[] = $allPermission['admin@invoice-list'];
        $clientPermission[] = $allPermission['admin@invoice-view'];
        $clientPermission[] = $allPermission['admin@invoice-get_tax'];
        $clientPermission[] = $allPermission['admin@invoice-payment'];
        $clientPermission[] = $allPermission['admin@invoice-payments'];
        $clientPermission[] = $allPermission['admin@invoice-payments-list'];
        $clientPermission[] = $allPermission['admin@invoice-paypal-cancel'];
        $clientPermission[] = $allPermission['admin@invoice-paypal-success'];
        $clientPermission[] = $allPermission['admin@invoice-pdf'];
        $clientPermission[] = $allPermission['admin@invoice-send'];
        $clientPermission[] = $allPermission['admin@invoice-twocheckout-cancel'];
        $clientPermission[] = $allPermission['admin@invoice-twocheckout-success'];
        $clientPermission[] = $allPermission['admin@quotation'];
        $clientPermission[] = $allPermission['admin@quotation-list'];
        $clientPermission[] = $allPermission['admin@quotation-view'];
        $clientPermission[] = $allPermission['admin@quotation-pdf'];
        $clientPermission[] = $allPermission['admin@quotation-send'];
        $clientPermission[] = $allPermission['admin@client-password-update'];
        $clientPermission[] = $allPermission['admin@client-view'];

        $clientID->attachPermissions($clientPermission);

        $user   = Config::get('installer.user');
        $inputs['confirmation_code'] = md5(uniqid(mt_rand(), true));
        $inputs['status']            = 1;
        $inputs['is_valid_email']    = 1;
        $inputs['img']               = 'public/assets/img/demo/admin.jpg';
        $inputs['password']          = bcrypt('admin');
        $inputs['username']          = 'admin';
        $inputs['email']             = 'admin@admin.com';
        $inputs['first_name']        = 'Mr.';
        $inputs['last_name']         = 'Admin';
        $user = $user::create($inputs);
        $user->attachRole($adminID);

        $inputs['status']            = 1;
        $inputs['img']               = 'public/assets/img/demo/default.png';
        $inputs['password']          = bcrypt('shipu');
        $inputs['username']          = 'shipu';
        $inputs['email']             = 'shipu@user.com';
        $inputs['first_name']        = 'Shipu';
        $inputs['last_name']         = 'Ahamed';
        $user = $user::create($inputs);
        $user->attachRole($userID);

        $inputs['status']            = 0;
        $inputs['img']               = 'public/assets/img/demo/default.png';
        $inputs['password']          = bcrypt('dipok');
        $inputs['username']          = 'dipok';
        $inputs['email']             = 'dipok@dipok.com';
        $inputs['first_name']        = 'Dipok';
        $inputs['last_name']         = 'Halder';
        $user = $user::create($inputs);
        $user->attachRole($userID);

        $inputs['status']            = 1;
        $inputs['img']               = 'public/assets/img/demo/default.png';
        $inputs['password']          = bcrypt('ridislam');
        $inputs['username']          = 'ridislam';
        $inputs['email']             = 'rid@rid.com';
        $inputs['first_name']        = 'Rid';
        $inputs['last_name']         = 'Islam';
        $user = $user::create($inputs);
        $user->attachRole($userID);

        $inputs['status']            = 1;
        $inputs['img']               = 'public/assets/img/demo/default.png';
        $inputs['password']          = bcrypt('123456');
        $inputs['username']          = 'client';
        $inputs['email']             = 'johndoe@client.com';
        $inputs['first_name']        = 'John';
        $inputs['last_name']         = 'Doe';
        $user = $user::create($inputs);
        $user->attachRole($clientID);
        $this->clientInfoAdd($user->id);

    }

    public function clientInfoAdd($id)
    {
        $faker = Faker\Factory::create();

        $result = DB::table('clients')->insert([
            'company' => "iNiLabs",
            'user_id' => $id,
            'address_line_one' => $faker->streetAddress,
            'address_line_two' => $faker->streetAddress,
            'city' => $faker->city,
            'state' => $faker->city,
            'zip_code'=> $faker->postcode,
            'phone'=> $faker->phoneNumber,
            'country' => $faker->country,
        ]);
        if ($result) {
            return true;
        }
        return false;
    }

    public function auto()
    {
        $routeCollection = Route::getRoutes();

        $f                      = false;
        $allRouteLikeDatabase   = [];
        foreach ($routeCollection as $value) {
            $middleware         =   false;
            if ( isset($value->getAction()['middleware']) && is_array($value->getAction()['middleware']) ) {
                $middleware     =   in_array('acl', $value->getAction()['middleware']);
            }

            if ($middleware) {
                $permission                     =   [];
                $explodeUrl                     =   explode('/', $value->getpath());
                $countExplode                   =   count($explodeUrl);

                for ($i = 1; $i <= $countExplode; $i++) {
                    if($explodeUrl[$i-1][0] != '{') {
                        if($i == 1) {
                            $permission['name']             =   $explodeUrl[$i-1];
                            $permission['display_name']     =   ucfirst($explodeUrl[$i-1]);
                        } elseif($i==2 && $explodeUrl[$i-2] == 'admin') {
                            $permission['name']             .=   '@'.$explodeUrl[$i-1];
                            $permission['display_name']     .=   ' '.ucfirst($explodeUrl[$i-1]);
                        } else {
                            $permission['name']             .=   '-'.$explodeUrl[$i-1];
                            $permission['display_name']     .=   ' '.ucfirst($explodeUrl[$i-1]);
                        }

                    }
                }

                $allRouteLikeDatabase[]         =   $permission['name'];
                if(isset($permission)) {
                    $status = $this->permissionRepo->firstOrCreate($permission);
                }
                if ($status->wasRecentlyCreated) {
                    $f  =   true;
                }
            }
        }

        $deletePermissionFromDatabaseWithCheckRoutes   =   array_count_values(array_merge($this->permissionRepo->getAllPermissions()->pluck('name')->all(), $allRouteLikeDatabase));

        foreach ($deletePermissionFromDatabaseWithCheckRoutes as $name => $value) {
            if($value == 1) {
                $this->permissionRepo->deleteWithPermissionName($name);
                $f  =   true;
            }
        }
    }
}
